/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.configuration;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.file.YamlConfiguration;
import org.magmafoundation.magma.commands.ModsCommand;
import org.magmafoundation.magma.configuration.ConfigBase;
import org.magmafoundation.magma.configuration.value.Value;
import org.magmafoundation.magma.configuration.value.values.BooleanValue;

public class MagmaConfig
extends ConfigBase {
    public static MagmaConfig instance = new MagmaConfig();
    public final BooleanValue forgeBukkitPermissionHandlerEnable = new BooleanValue(this, "forge.bukkitPermissionHandler.enable", true, "Let's Bukkit permission plugins handle forge/modded commands");
    public final BooleanValue forgeCommandsIgnoreBukkitPerms = new BooleanValue(this, "forge.commandsIgnoreBukkitPerms", true, "If true, forge/modded commands will ignore Bukkit permission plugins and use Forge permissions instead, disable this to control forge commands with permission plugins like LuckPerms");
    public final BooleanValue magmaAutoUpdater = new BooleanValue(this, "magma.auto-update", true, "Auto updates the Magma jar");
    public final BooleanValue modCommandPrintIDs = new BooleanValue(this, "magma.command.mods.print-ids", true, "Adds the mod id + version to the end of the mod name");
    public final BooleanValue debugPrintInjections = new BooleanValue(this, "debug.print-bukkit-injections", false, "Prints Forge Bukkit Injections");
    public final BooleanValue debugWarnOnNullNBT = new BooleanValue(this, "debug.warn-on-null-nbt", false, "Prints a warning when an item tries to set an NBT tag to null");
    private final String HEADER = "This is the main configuration file for Magma.\n\nSite: https://magmafoundation.org\nDiscord: https://discord.gg/magma\n";

    public MagmaConfig() {
        super("magma.yml", "magma");
        this.init();
    }

    public static String getString(String s, String key, String defaultreturn) {
        if (s.contains(key)) {
            String string = s.substring(s.indexOf(key));
            String s1 = string.substring(string.indexOf(": ") + 2);
            String[] ss = s1.split("\n");
            return ss[0].trim().replace("'", "").replace("\"", "");
        }
        return defaultreturn;
    }

    public static String getString(File f, String key, String defaultreturn) {
        try {
            String s = FileUtils.readFileToString((File)f, (String)"UTF-8");
            if (s.contains(key)) {
                String string = s.substring(s.indexOf(key));
                String s1 = string.substring(string.indexOf(": ") + 2);
                String[] ss = s1.split("\n");
                return ss[0].trim().replace("'", "").replace("\"", "");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return defaultreturn;
    }

    public void init() {
        for (Field f : this.getClass().getFields()) {
            if (!Modifier.isFinal(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
            try {
                Value value = (Value)f.get(this);
                if (value == null) continue;
                this.values.put(value.path, value);
            }
            catch (ClassCastException value) {
            }
            catch (Throwable t) {
                System.out.println("[Magma] Failed to initialize a MagmaConfig values.");
                t.printStackTrace();
            }
        }
        this.load();
    }

    @Override
    protected void addCommands() {
        this.commands.put("mods", new ModsCommand("mods"));
    }

    @Override
    protected void load() {
        try {
            this.config = YamlConfiguration.loadConfiguration(this.configFile);
            StringBuilder header = new StringBuilder("This is the main configuration file for Magma.\n\nSite: https://magmafoundation.org\nDiscord: https://discord.gg/magma\n\n");
            for (Value toggle : this.values.values()) {
                if (!toggle.description.equals("")) {
                    header.append("Value: ").append(toggle.path).append(" Default: ").append(toggle.key).append("   # ").append(toggle.description).append("\n");
                }
                this.config.addDefault(toggle.path, toggle.key);
                ((Value)this.values.get(toggle.path)).setValues(this.config.getString(toggle.path));
            }
            this.version = this.getInt("config-version", 1);
            this.set("config-version", 1);
            this.config.options().header(header.toString());
            this.config.options().copyDefaults(true);
            this.save();
        }
        catch (Exception ex) {
            MinecraftServer.getServer().server.getLogger().log(Level.SEVERE, "Could not load " + this.configFile);
            ex.printStackTrace();
        }
    }
}

